﻿using VA.TMP.Integration.VIMT.Messages.VideoVisit;
using VA.TMP.Integration.VIMT.Shared;
using VA.TMP.Integration.VIMT.VideoVisit.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.VideoVisit.PipelineSteps.Delete
{
    /// <summary>
    /// Create Response step.
    /// </summary>
    public class CreateResponseStep : FilterBase<VideoVisitDeleteStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(VideoVisitDeleteStateObject state)
        {
            if (!string.IsNullOrEmpty(state.VistaFakeResponseType))
            {
                var fakeEcResponse = VistaSchedulingUtilities.CreateFakeCancelResult(state.VistaFakeResponseType, state);
                state.VideoVisitDeleteResponseMessage = new VideoVisitDeleteResponseMessage
                    {
                        ExceptionMessage = "*****THIS IS FAKE DATA. DATA NOT SENT TO VVS*****",
                        ExceptionOccured = false,
                        SerializedInstance = state.SerializedAppointment,
                        WriteResults = VistaSchedulingUtilities.MapEcToWriteResult(fakeEcResponse)
                    };
            }
            else
            {
                state.VideoVisitDeleteResponseMessage = state.ExceptionOccured
                    ? new VideoVisitDeleteResponseMessage { ExceptionOccured = true, ExceptionMessage = state.ExceptionMessage, EcProcessingMs = state.EcProcessingTimeMs }
                    : new VideoVisitDeleteResponseMessage
                    {
                        ExceptionMessage = string.Empty,
                        ExceptionOccured = false,
                        SerializedInstance = state.SerializedAppointment,
                        WriteResults = VistaSchedulingUtilities.MapEcToWriteResult(state.EcResponse.VIMTTmpCancelAppointmentResponseDataInfo.VIMTTmpWriteResults),
                        EcProcessingMs = state.EcProcessingTimeMs
                    };
            }
        }
    }
}